/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CPropertyPage.cpp,v 1.2 1999/12/22 10:05:04 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CPropertyPage.h"

_USING_PGP

// Class CPropertyPage ember functions

void 
CPropertyPage::Create(const char *title)
{
	pgpAssert(!IsCreated());

	pgpClearMemory(&mPSP, sizeof(mPSP));

	mPSP.dwSize = sizeof(mPSP);
	mPSP.dwFlags = PSP_HASHELP;

	if (IsntNull(title))
	{
		mPSP.dwFlags |= PSP_USETITLE;
		mPSP.pszTitle = title;
	}

	PreCreateHook();
	CreateAsPropPage(mPSP, mPageHandle);
}

void 
CPropertyPage::EndPropertyDialog(CComboError error)
{
	HandleWindowError(error);
}

void 
CPropertyPage::OnNcDestroy()
{
	mPageHandle = NULL;
	CDialog::OnNcDestroy();
}

PGPUInt32 
CPropertyPage::OnNotify(PGPUInt16 ctrlId, LPNMHDR pNMHDR)
{
	pgpAssertAddrValid(pNMHDR, NMHDR);

	PGPUInt32	result	= 0;
	PSHNOTIFY	*pSHN	= reinterpret_cast<PSHNOTIFY *>(pNMHDR);

	switch (pNMHDR->code)
	{
	case PSN_APPLY:
		if (OnPsnApply(static_cast<PGPBoolean>(pSHN->lParam)))
			result = PSNRET_NOERROR;
		else
			result = PSNRET_INVALID_NOCHANGEPAGE;
		break;

	case PSN_HELP:
		OnPsnHelp();
		break;

	case PSN_KILLACTIVE:
		result = OnPsnKillActive();
		SetWindowLong(DWL_MSGRESULT, result);
		break;

	case PSN_QUERYCANCEL:
		if (*mPSkipConfirmCancel)
		{
			result = FALSE;
			pgpAssert(mPError->IsError());
		}
		else
		{
			result = OnPsnQueryCancel();

			if (result == FALSE)
				mPError->pgpErr = kPGPError_UserAbort;
		}

		SetWindowLong(DWL_MSGRESULT, result);
		break;

	case PSN_RESET:
		OnPsnReset(static_cast<PGPBoolean>(pSHN->lParam));
		break;

	case PSN_SETACTIVE:
		result = OnPsnSetActive();
		SetWindowLong(DWL_MSGRESULT, result);
		break;

	case PSN_WIZBACK:
		result = OnPsnWizBack();
		SetWindowLong(DWL_MSGRESULT, result);
		break;

	case PSN_WIZFINISH:
		result = OnPsnWizFinish();
		SetWindowLong(DWL_MSGRESULT, result);
		break;

	case PSN_WIZNEXT:
		result = OnPsnWizNext();
		SetWindowLong(DWL_MSGRESULT, result);
		break;

	default:
		result = CDialog::OnNotify(ctrlId, pNMHDR);
		break;
	}

	return result;
}

void 
CPropertyPage::HandleWindowError(CComboError error)
{
	*mPError = error;
	*mPSkipConfirmCancel = TRUE;

	PressButton(PSBTN_CANCEL);
}

void 
CPropertyPage::SetVariables(CComboError *pError, PGPBoolean *pSkipConfirmCancel)
{
	pgpAssertAddrValid(pError, CComboError);

	mPError = pError;
	mPSkipConfirmCancel = pSkipConfirmCancel;
}

BOOL 
CPropertyPage::OnCommand(
	PGPUInt16	notifyCode, 
	PGPUInt16	itemId, 
	HWND		ctrl)
{
	if (notifyCode == BN_CLICKED)
	{
		CComboError	error;

		switch (itemId)
		{
		case IDCANCEL:
			if (error.IsntError())	// leave old error
				error.pgpErr = kPGPError_UserAbort;

			EndPropertyDialog(error);
			return TRUE;
		}
	}

	return CDialog::OnCommand(notifyCode, itemId, ctrl);
}
